TOOL=linux
#TOOL=3559
#TOOL="aarch64"
#TOOL="armV7"

export LIBS=$TOOL
DIR_LIB="./lib/$TOOL"

if [ $TOOL == "linux" ] 
then
	echo "linux"
	if [ ! -d "$DIR_LIB" ];then
		mkdir "$DIR_LIB"
		echo "$DIR_LIB no exist !"
	fi
	export CC=gcc
	export CXX=g++
	export CPP=g++
	export AS=as
	export LD=ld
	export GDB=gdb
	export STRIP=strip
	export RANLIB=ranlib
	export OBJCOPY=objcopy
	export OBJDUMP=objdump
	export AR=ar
	export NM=nm
fi

if [ $TOOL == "3559" ] 
then
	echo "3559"
	if [ ! -d "$DIR_LIB" ];then
		mkdir "$DIR_LIB"
		echo "$DIR_LIB no exist !"
	fi
	export PATH=/opt/gcc-linaro-arm-linux-gnueabihf-4.7-2013.03-20130313_linux/bin:$PATH
	export CC=arm-linux-gnueabihf-gcc
	export CXX=arm-linux-gnueabihf-g++
	export CPP=arm-linux-gnueabihf-g++
	export AS=arm-linux-gnueabihf-as
	export LD=arm-linux-gnueabihf-ld
	export GDB=arm-linux-gnueabihf-gdb
	export STRIP=arm-linux-gnueabihf-strip
	export RANLIB=arm-linux-gnueabihf-ranlib 
	export OBJCOPY=arm-linux-gnueabihf-objcopy
	export OBJDUMP=arm-linux-gnueabihf-objdump
	export AR=arm-linux-gnueabihf-ar
	export NM=arm-linux-gnueabihf-nm
fi

if [ $TOOL == "aarch64" ] 
then
	echo "aarch64"
	if [ ! -d "$DIR_LIB" ];then
		mkdir "$DIR_LIB"
		echo "$DIR_LIB no exist !"
	fi
	export PATH=/home/CXYuan/APP/gcc-linaro-7.5.0-2019.12-x86_64_aarch64-linux-gnu/bin:$PATH
	export CC=aarch64-linux-gnu-gcc
	export CXX=aarch64-linux-gnu-g++
	export CPP=aarch64-linux-gnu-g++
	export AS=aarch64-linux-gnu-as
	export LD=aarch64-linux-gnu-ld
	export GDB=aarch64-linux-gnu-gdb
	export STRIP=aarch64-linux-gnu-strip
	export RANLIB=aarch64-linux-gnu-ranlib
	export OBJCOPY=aarch64-linux-gnu-objcopy
	export OBJDUMP=aarch64-linux-gnu-objdump
	export AR=aarch64-linux-gnu-ar
	export NM=aarch64-linux-gnu-nm
fi

if [ $TOOL == "armV7" ] 
then
	echo "armV7"
	if [ ! -d "$DIR_LIB" ];then
		mkdir "$DIR_LIB"
		echo "$DIR_LIB no exist !"
	fi
	export PATH=/home/CXYuan/APP/gcc-linaro-7.5.0-2019.12-x86_64_arm-linux-gnueabihf/bin:$PATH
	export CC=arm-linux-gnueabihf-gcc
	export CXX=arm-linux-gnueabihf-g++
	export CPP=
	export AS=arm-linux-gnueabihf-as
	export LD=arm-linux-gnueabihf-ld
	export GDB=arm-linux-gnueabihf-gdb
	export STRIP=arm-linux-gnueabihf-strip
	export RANLIB=arm-linux-gnueabihf-ranlib
	export OBJCOPY=arm-linux-gnueabihf-objcopy
	export OBJDUMP=arm-linux-gnueabihf-objdump
	export AR=arm-linux-gnueabihf-ar
	export NM=arm-linux-gnueabihf-nm
fi

export M4=m4
export CFLAGS=" -O2 -fPIC -pipe -g -feliminate-unused-debug-types"
export CXXFLAGS=" -O2 -fPIC -pipe -g -feliminate-unused-debug-types"
export LDFLAGS="-Wl,-O1 -fPIC -Wl,--hash-style=gnu -Wl,--as-needed"
export CPPFLAGS="-fPIC"
export CPP_FLAGS=" -O2 -pipe -D__RJ_LINUX32__ -DX86 -Wl,-Bsymnolic -D__JY_IMX6__ -fPIC"
export version=
